<?php
/**
 * 'slick-slider' Design 4 Shortcodes HTML
 *
 * @package WP Slick Slider and Image Carousel
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<div class="wpsisac-image-slide">
	<div class="wpsisac-slide-wrap wp-medium-12 wpcolumns">
		<div class="wpsisac-content-left wp-medium-7 wpcolumns">
			<h2 class="wpsisac-slide-title"><?php the_title(); ?></h2>
			<?php if( $show_content ) { ?>
				<div class="wpsisac-slider-short-content"><?php the_content(); ?></div>
			<?php }
			$sliderurl = get_post_meta( get_the_ID(),'wpsisac_slide_link', true );
			if( $sliderurl != '' ) { ?>
				<div class="wpsisac-readmore"><a href="<?php echo esc_url($sliderurl); ?>" class="wpsisac-slider-readmore"><?php esc_html_e( 'Read More', 'wp-slick-slider-and-image-carousel' ); ?></a></div>
			<?php } ?>
		</div>
		<div class="wpsisac-content-right wp-medium-5 wpcolumns">
			<img <?php if( $lazyload ) { ?>data-lazy="<?php echo esc_url($slider_img); ?>" <?php } ?> src="<?php if(empty($lazyload)) { echo esc_url($slider_img); } ?>" alt="<?php the_title(); ?>" />
		</div>
	</div>
</div>