<?php

/*
 * Plugin Name: Super Video Player
 * Plugin URI:  https://bplugins.com/super-video-player
 * Description: A fully customizable video player for wordpress.
 * Version: 1.4.1
 * Author: bPlugins LLC
 * Author URI: http://bplugins.com
 * Text Domain:  bPlugins
 * Domain Path:  /languages
 */

if ( !function_exists( 'svp_fs' ) ) {
    // Create a helper function for easy SDK access.
    function svp_fs()
    {
        global  $svp_fs ;
        
        if ( !isset( $svp_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_6749_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_6749_MULTISITE', true );
            }
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/freemius/start.php';
            $svp_fs = fs_dynamic_init( array(
                'id'             => '6749',
                'slug'           => 'super-video-player',
                'type'           => 'plugin',
                'public_key'     => 'pk_ebfc28616ca46b064866ea36660e0',
                'is_premium'     => false,
                'premium_suffix' => 'Pro',
                'has_addons'     => false,
                'has_paid_plans' => true,
                'trial'          => array(
                'days'               => 7,
                'is_require_payment' => false,
            ),
                'menu'           => array(
                'slug'       => 'edit.php?post_type=svplayer',
                'first-path' => 'edit.php?post_type=svplayer&page=svp-notice',
                'network'    => true,
            ),
                'is_live'        => true,
            ) );
        }
        
        return $svp_fs;
    }
    
    // Init Freemius.
    svp_fs();
    // Signal that SDK was initiated.
    do_action( 'svp_fs_loaded' );
}

// Load Textdomain
function svp_load_textdomain()
{
    load_plugin_textdomain( 'bPlugins', false, dirname( __FILE__ ) . "/languages" );
}

add_action( "plugins_loaded", 'svp_load_textdomain' );
/*Some Set-up*/
define( 'SVP_PLUGIN_DIR', WP_PLUGIN_URL . '/' . plugin_basename( dirname( __FILE__ ) ) . '/' );
define( 'SVP_VERSION', '1.4.1' );
/* JS*/

if ( !function_exists( 'svp_get_script' ) ) {
    function svp_get_script()
    {
        wp_enqueue_script(
            'svp-js',
            plugin_dir_url( __FILE__ ) . 'public/js/super-video.js',
            array(),
            SVP_VERSION,
            false
        );
    }
    
    add_action( 'wp_enqueue_scripts', 'svp_get_script' );
}

// HLS and SHAKA

if ( !function_exists( 'svp_streaming_script' ) ) {
    function svp_streaming_script()
    {
        wp_register_script(
            'svp-hls-js',
            plugin_dir_url( __FILE__ ) . 'public/js/hls.js',
            array(),
            SVP_VERSION,
            false
        );
        wp_register_script(
            'svp-shaka-js',
            plugin_dir_url( __FILE__ ) . 'public/js/shaka.js',
            array(),
            SVP_VERSION,
            false
        );
    }
    
    add_action( 'init', 'svp_streaming_script' );
}

function svp_style()
{
    wp_enqueue_style(
        'svp-style',
        plugin_dir_url( __FILE__ ) . 'public/css/player-style.css',
        array(),
        SVP_VERSION,
        'all'
    );
}

add_action( 'wp_enqueue_scripts', 'svp_style' );
/*-------------------------------------------------------------------------------*/
/* HIDE everything in PUBLISH metabox except Move to Trash & PUBLISH button
/*-------------------------------------------------------------------------------*/
function svp_hide_publishing_actions()
{
    $my_post_type = 'svplayer';
    global  $post ;
    if ( $post->post_type == $my_post_type ) {
        echo  '
                <style type="text/css">
                    #misc-publishing-actions,
                    #minor-publishing-actions{
                        display:none;
                    }
                </style>
            ' ;
    }
}

add_action( 'admin_head-post.php', 'svp_hide_publishing_actions' );
add_action( 'admin_head-post-new.php', 'svp_hide_publishing_actions' );
//Remove post update massage and link
function svp_updated_messages( $messages )
{
    $messages['svplayer'][1] = __( 'Updated' );
    return $messages;
}

add_filter( 'post_updated_messages', 'svp_updated_messages' );
/* Register Custom Post Types */
add_action( 'init', 'svp_create_post_type' );
function svp_create_post_type()
{
    register_post_type( 'svplayer', array(
        'labels'              => array(
        'name'          => __( 'Super Video Player' ),
        'singular_name' => __( 'Player' ),
        'add_new'       => __( 'Add New' ),
        'add_new_item'  => __( 'Add new item' ),
        'edit_item'     => __( 'Edit' ),
        'new_item'      => __( 'New' ),
        'view_item'     => __( 'View' ),
        'search_items'  => __( 'Search' ),
        'not_found'     => __( 'Sorry, we couldn\'t find any item you are looking for.' ),
    ),
        'public'              => false,
        'show_ui'             => true,
        'publicly_queryable'  => true,
        'exclude_from_search' => true,
        'show_in_rest'        => true,
        'menu_position'       => 14,
        'menu_icon'           => SVP_PLUGIN_DIR . 'img/icon.png',
        'has_archive'         => false,
        'hierarchical'        => false,
        'capability_type'     => 'page',
        'rewrite'             => array(
        'slug' => 'svplayer',
    ),
        'supports'            => array( 'title', 'thumbonail' ),
    ) );
}

// ONLY OUR CUSTOM TYPE POSTS
add_filter( 'manage_svplayer_posts_columns', 'svp_column_handler', 10 );
add_action(
    'manage_svplayer_posts_custom_column',
    'svp_column_content_handler',
    10,
    2
);
// CREATE TWO FUNCTIONS TO HANDLE THE COLUMN
function svp_column_handler( $defaults )
{
    $defaults['directors_name'] = 'ShortCode';
    return $defaults;
}

function svp_column_content_handler( $column_name, $post_ID )
{
    if ( $column_name == 'directors_name' ) {
        // show content of 'directors_name' column
        echo  '<input onClick="this.select();" value="[vplayer id=' . $post_ID . ']" >' ;
    }
}

// Review Request as metabox
function svp_review_request_metabox()
{
    add_meta_box(
        'myplugin_sectionid',
        __( 'Please show some love', 'myplugin_textdomain' ),
        'svp_review_callback',
        'svplayer',
        'side'
    );
}

add_action( 'add_meta_boxes', 'svp_review_request_metabox' );
function svp_review_callback()
{
    echo  '

<p>If you like <strong>Super Video Player</strong> Plugin, please leave us a <a href="https://wordpress.org/support/plugin/super-video-player/reviews/?filter=5#new-post" target="_blank">&#9733;&#9733;&#9733;&#9733;&#9733; rating</a> . Your Review is very important to us as it helps us to grow more.</p>

<p>Not happy, Sorry for that. You can request for improvement. </p>

<table>
	<tr>
		<td><a class="button button-primary button-large" href="https://wordpress.org/support/plugin/super-video-player/reviews/?filter=5#new-post" target="_blank">Write Review</a></td>
		<td><a class="button button-primary button-large" href="mailto:abuhayat.du@gmail.com" target="_blank">Request Improvement</a></td>
	</tr>
</table>

' ;
}

// Footer Review Request
add_filter( 'admin_footer_text', 'svp_admin_footer' );
function svp_admin_footer( $text )
{
    
    if ( 'svplayer' == get_post_type() ) {
        $url = 'https://wordpress.org/support/plugin/super-video-player/reviews/?filter=5#new-post';
        $text = sprintf( __( 'If you like <strong>Super Video Player</strong> please leave us a <a href="%s" target="_blank">&#9733;&#9733;&#9733;&#9733;&#9733;</a> rating. Your Review is very important to us as it helps us to grow more. ', 'post-carousel' ), $url );
    }
    
    return $text;
}

//  Notice Page
add_action( 'admin_menu', 'svp_notice_page' );
function svp_notice_page()
{
    add_submenu_page(
        'edit.php?post_type=svplayer',
        'Important Notice',
        'Important Notice',
        'manage_options',
        'svp-notice',
        'svp_notice_page_callback'
    );
}

function svp_notice_page_callback()
{
    echo  '<div class="wrap"><div id="icon-tools" class="icon32"></div>
		<div style="padding:20px" class="notice notice-success">
			<b style="font-size:24px;">This Important Notice is for older users only, who updating Super Video Player to Latest Version. If you just installed this plugin you can avoid this notice.</b>
			<p style="font-size:17px;margin:0;">In <strong>Super Video Player </strong> <em>Version 1.3</em> we updated our plugins framework to make this plugin compatible with WordPress 5.5 or later! You may encountered some unexpected behavior on players and misconfiguration on some players in backend &#128557;  Please consider reconfiguring them accourding to your preferance and update them. We are sorry for any inconvenience this may have caused.
			<p  style="font-size:12px;margin:2px; display:none;" >You can change the options of Quick Player/ShortCode <a class="button button-primary" href="options-general.php?page=html5vp_settings">Here</a></p>
		</div>
		</div>' ;
}

// Add shortcode fields in edit screen
add_action( 'edit_form_after_title', 'svp_shortcode_area' );
function svp_shortcode_area()
{
    global  $post ;
    
    if ( $post->post_type == 'svplayer' ) {
        ?>	
<div>
	<label style="cursor: pointer;font-size: 13px; font-style: italic;" for="svp_shortcode">Copy this shortcode and paste it into your post, page, or text widget content:</label>
	<span style="display: block; margin: 5px 0; background:#1e8cbe; ">
		<input type="text" id="svp_shortcode" style="font-size: 15px; border: none; box-shadow: none;padding: 4px 8px; width:100%; background:transparent; color:white;"  onfocus="this.select();" readonly="readonly"  value="[vplayer id=<?php 
        echo  $post->ID ;
        ?>]" /> 
		
	</span>
</div>
 <?php 
    }

}

// Inc  common
include_once 'admin/blocks/init.php';
require_once 'admin/codestar-framework/codestar-framework.php';
require_once 'inc/notice.php';
require_once 'admin/inc/help-usages.php';

if ( svp_fs()->is_free_plan() ) {
    // Free version code
    require_once 'admin/codestar-framework/metabox-free.php';
    require_once 'inc/shortcode-free.php';
}
